module Tiled
  include Tiled::Serializable
  include Tiled::WithAttributes

  attributes :id, :name, :x, :y, :width, :height, :opacity, :visible, :text, :wrap
  class Text
    def initialize(attribs)
      obj = attribs.first[:children]
      cattr = attribs.first[:attributes]
      # puts cattr
      text = obj.first[:data]
      attributes.add(
        text: Tiled::Text.new(),
        wrap: cattr['wrap'],
        color: Tiled::Color.from_tiled_rgba(cattr['color'])
      )
      %w[width height].each { |attr| attribs.add(attr => attrs[attr].to_f) }
      attributes.add(
        'y' => map.pixelheight - (attribs['y'].to_f + (object_type == :tile ? 0 : height)),
        'x' => attrs['x']
      )
      attributes.add(
        text: text,
        name: name,
        width: width,
        height: height,
        opacity: opacity,
        visible: visible
      )
    end

    def inspect
      "#<#{self.class.name} #{to_s} >"
    end
    def to_s
      "#<#{self.class.name} text: #{:text}>"
    end
  end
end